/** @file   HiddenWormAi.cpp
 * @brief   Implementation of HiddenWormAi class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/04/25 17:56:11 $
 * @author  Tomi Lamminsaari
 */

#include "HiddenWormAi.h"
#include "WarGlobals.h"
#include "Utils.h"
using eng2d::Vec2D;

namespace WeWantWar {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
HiddenWormAi::HiddenWormAi( GameObject* aMaster ) :
  BaseController( aMaster ),
  m_attackDistance( 160 )
{
}



/** Destructor.
 */
HiddenWormAi::~HiddenWormAi()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

void HiddenWormAi::update()
{
  m_counter -= 1;
  if ( m_counter > 0 ) {
    return;
  }
  
  GameObject* target = WarGlobals::pObjTable->pPrimaryTarget;
  if ( m_pObject == 0 || target == 0 ) {
    m_counter = 10;
    return;
  }
  
  int d = Utils::findTurningDir( m_pObject->position(), target->position(),
                                 m_pObject->angle() );
  m_turn = 2*d;
  Vec2D distVec = target->position() - m_pObject->position();
  if ( distVec.length() < m_attackDistance ) {
    m_shoot = 1;
  }
  m_counter = 2;
}




///
/// New public methods
/// ============================================================================




///
/// Getter methods
/// ============================================================================




///
/// Protected and private methods
/// ============================================================================


};  // end of namespace
